﻿using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class MapToProGetConsultsRequest:FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            if (!state.IsStoreForward)
            {
                state.ProEcRequest = new GetConsultsforPatientMapper().mapGetConsultRequest(state, Side.Provider, Logger.Instance);
                if (state.ProEcRequest != null)
                {
                    var siteNum = state.ProEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqpatientInfo.mcs_localSiteId;
                    if (string.IsNullOrEmpty(state.ProUserDuz))
                        state.ProLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy, state.SamlToken);
                    else
                        state.ProEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqproviderInfo.mcs_userId = state.ProUserDuz;
                }
            }
            else
            {
                Logger.Instance.Debug("skipping Provider Side for ViaGetConsults.");
            }
        }
    }
}
